/*
 * Decompiled with CFR 0.152.
 */
package googleAddressLocation;

import googleAddressLocation.GoogleMaps;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class MapView
extends GameCanvas {
    private GoogleMaps m_gMap = new GoogleMaps("ABQIAAAAKiUyung45DaGPzYkmwof8hRppSN06F9zva_dcFabUSZobodK-RSMgyh9npi8tuZlH7o4xLZTkBKH5Q");
    Image m_mapImg;
    private InteractTask m_interactTask;
    private boolean m_runing;
    private final Object m_syncObj = new Object();
    private boolean m_isInteractBusy;
    private double[] m_currCenterLG;
    private double[] m_ptLG;
    private int m_zoomLevel = 14;
    private int m_deltaX = 0;
    private int m_deltaY = 0;
    private int m_imgW = 480;
    private int m_imgH = 640;
    private int m_canvasW;
    private int m_canvasH;

    public MapView() {
        super(false);
        this.setFullScreenMode(true);
        this.m_canvasW = this.getWidth();
        this.m_canvasH = this.getHeight();
    }

    public void keyRepeated(int n2) {
        if (!this.m_isInteractBusy) {
            this.keyPressed(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int n2) {
        this.m_interactTask.m_keyCode = n2;
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
    }

    protected final void startInteract() {
        if (this.m_interactTask == null) {
            this.m_runing = true;
            this.m_interactTask = new InteractTask();
            new Thread(this.m_interactTask).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopInteract() {
        this.m_runing = false;
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
        this.m_currCenterLG = null;
        this.m_interactTask = null;
        this.m_mapImg = null;
        this.m_gMap.destroy();
        this.m_gMap = null;
        this.m_ptLG = null;
    }

    private void newMap() {
        try {
            this.m_currCenterLG = this.m_gMap.adjust(this.m_currCenterLG[0], this.m_currCenterLG[1], this.m_deltaX, this.m_deltaY, this.m_zoomLevel);
            this.m_mapImg = this.m_gMap.retrieveStaticImage(this.m_imgW, this.m_imgH, this.m_currCenterLG[0], this.m_currCenterLG[1], this.m_zoomLevel, "png32");
            this.m_deltaX = 0;
            this.m_deltaY = 0;
            this.render();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void move(int n2, int n3) {
        try {
            this.m_deltaX += n2;
            this.m_deltaY += n3;
            if (this.m_imgW / 2 - Math.abs(this.m_deltaX) < this.m_canvasW / 2 || this.m_imgH / 2 - Math.abs(this.m_deltaY) < this.m_canvasH / 2) {
                this.newMap();
            }
            this.render();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final String getPos() {
        return "N" + this.m_currCenterLG[0] + " E" + this.m_currCenterLG[1];
    }

    public void findAndShowMap(String string) {
        try {
            this.m_currCenterLG = this.m_gMap.geocodeAddress(string);
            this.m_ptLG = this.m_currCenterLG;
            this.m_mapImg = this.m_gMap.retrieveStaticImage(this.m_imgW, this.m_imgH, this.m_currCenterLG[0], this.m_currCenterLG[1], this.m_zoomLevel, "png32");
            this.render();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.m_mapImg != null) {
            graphics.drawImage(this.m_mapImg, this.getWidth() / 2 + this.m_deltaX, this.getHeight() / 2 + this.m_deltaY, 3);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("* Zoom-   # Zoom+", this.getWidth() / 2, this.getHeight() - 22, 17);
            graphics.setColor(0);
            graphics.drawString("* Zoom-   # Zoom+", this.getWidth() / 2 - 1, this.getHeight() - 21, 17);
        } else {
            graphics.setColor(0xFF0000);
            graphics.drawString("Loading...", this.getWidth() / 2, this.getHeight() / 2, 17);
        }
        this.flushGraphics();
    }

    public void showNotify() {
        this.render();
    }

    static /* synthetic */ double[] access$202(MapView mapView, double[] dArray) {
        mapView.m_currCenterLG = dArray;
        return dArray;
    }

    class InteractTask
    implements Runnable {
        private int m_keyCode = Integer.MAX_VALUE;

        InteractTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (MapView.this.m_runing) {
                try {
                    MapView.this.m_isInteractBusy = true;
                    System.out.println("findAndShowMap p_stName=" + this.m_keyCode);
                    if (this.m_keyCode < 0) {
                        this.m_keyCode = MapView.this.getGameAction(this.m_keyCode);
                        System.out.println(" -> p_stName=" + this.m_keyCode);
                    }
                    switch (this.m_keyCode) {
                        case 8: {
                            System.out.println("    -> Canvas.FIRE");
                            MapView.access$202(MapView.this, MapView.this.m_ptLG);
                            MapView.this.move(-MapView.this.m_deltaX, -MapView.this.m_deltaY);
                            break;
                        }
                        case 2: {
                            System.out.println("    -> Canvas.LEFT");
                            MapView.this.move(8, 0);
                            break;
                        }
                        case 5: {
                            System.out.println("    -> Canvas.LEFT");
                            MapView.this.move(-8, 0);
                            break;
                        }
                        case 6: {
                            System.out.println("    -> Canvas.DOWN");
                            MapView.this.move(0, -8);
                            break;
                        }
                        case 1: {
                            System.out.println("    -> Canvas.UP");
                            MapView.this.move(0, 8);
                            break;
                        }
                        case 49: {
                            System.out.println("    -> Canvas.KEY_NUM1");
                            break;
                        }
                        case 42: {
                            System.out.println("    -> Canvas.KEY_STAR");
                            if (MapView.this.m_zoomLevel <= 0) break;
                            MapView.this.m_zoomLevel--;
                            MapView.this.newMap();
                            break;
                        }
                        case 35: {
                            System.out.println("    -> Canvas.KEY_POUND");
                            if (MapView.this.m_zoomLevel >= 17) break;
                            MapView.this.m_zoomLevel++;
                            MapView.this.newMap();
                            break;
                        }
                        default: {
                            System.out.println("    -> UNKNOWN KEY");
                        }
                    }
                    Object object = MapView.this.m_syncObj;
                    synchronized (object) {
                        MapView.this.m_isInteractBusy = false;
                        MapView.this.m_syncObj.wait();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("findAndShowMap END THREAD!!!");
        }
    }
}

