/*
 * Decompiled with CFR 0.152.
 */
package googleAddressLocation;

import googleAddressLocation.BitUtils;
import googleAddressLocation.MicroDouble;

public final class MicroFloat {
    public static final int POSITIVE_INFINITY = 2139095040;
    public static final int NEGATIVE_INFINITY = -8388608;
    public static final int NaN = 2143289344;
    public static final int MAX_VALUE = 0x7F7FFFFF;
    public static final int MIN_VALUE = 1;
    public static final int E = 1076754516;
    public static final int PI = 1078530011;
    public static final int ZERO = 0;
    public static final int NEGATIVE_ZERO = Integer.MIN_VALUE;
    public static final int ONE = 1065353216;
    public static final int TWO = 0x40000000;
    public static final int ONE_HALF = 0x3F000000;
    private static final int ABS_MASK = Integer.MAX_VALUE;
    private static final int SIGN_MASK = Integer.MIN_VALUE;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int FRACTION_MASK = 0x7FFFFF;
    private static final int IMPLIED_ONE = 0x800000;
    private static final int[] pow10m = new int[]{-1003958181, -1723866425, -277622185, -1156416428, -1842974431, -463728444, -1301811943, -1956564676, -641213203, -1440471911, -2064892776, -810475859, -1572708361, -41437709, -971897307, -1698818867, -238485375, -1125840795, -1819087217, -426404673, -1272652747, -1933784055, -605618481, -1412663534, -2043167482, -776530087, -1546188227, Integer.MIN_VALUE, -939524096, -1673527296, -198967296, -1094967296, -1794967296, -388717296, -1243209483, -1910781505, -569676998, -1384584250, -2021230542, -742253617, -1519409734, -2126562951, -906835507, -1647989336, -159064233, -1063793028, -1770612399};
    private static final short[] pow10x = new short[]{-211, -204, -198, -191, -184, -178, -171, -164, -158, -151, -144, -138, -131, -125, -118, -111, -105, -98, -91, -85, -78, -71, -65, -58, -51, -45, -38, -31, -25, -18, -12, -5, 2, 8, 15, 22, 28, 35, 42, 48, 55, 62, 68, 75, 81, 88, 95};
    private static final int[] pow2m = new int[]{-1285701758, 770371978, 1972152263, 504870979, 1292469707, -986244846, 847032947, -2126562951, 555111512, 1421085472, -656988489, 931322575, -1910781505, 610351563, 1562500000, -294967296, 1024000000, -1673527296, 0x28000000, 0x66666666, 439804651, 1125899907, -1412663534, 737869763, 1888946593, 483570328, 1237940039, -1125840795, 811296384, 2076918743, 531691198, 1361129468};
    private static final byte[] pow2x = new byte[]{-45, -42, -40, -37, -35, -33, -30, -28, -25, -23, -21, -18, -16, -13, -11, -9, -6, -4, -1, 1, 4, 6, 8, 11, 13, 16, 18, 20, 23, 25, 28, 30};
    private final int value;

    static boolean unpackSign(int n2) {
        return n2 < 0;
    }

    static int unpackExponent(int n2) {
        return (n2 >> 23 & 0xFF) - 150;
    }

    static int unpackMantissa(int n2) {
        if ((n2 & 0x7F800000) == 0) {
            return (n2 & 0x7FFFFF) << 1;
        }
        return n2 & 0x7FFFFF | 0x800000;
    }

    static int pack(boolean bl2, int n2, int n3) {
        int n4 = BitUtils.countLeadingZeros(n3);
        return MicroFloat.pack2(bl2, n2 -= n4, n3 <<= n4);
    }

    static int pack(boolean bl2, int n2, long l2) {
        int n3 = 32 - BitUtils.countLeadingZeros(l2);
        n2 += n3;
        if (n3 > 0) {
            l2 = BitUtils.stickyRightShift(l2, n3);
        } else if (n3 < 0) {
            l2 <<= -n3;
        }
        return MicroFloat.pack2(bl2, n2, (int)l2);
    }

    private static int pack2(boolean bl2, int n2, int n3) {
        if (n3 != 0) {
            if (n2 < -157) {
                n3 = BitUtils.roundingRightShift(n3, -149 - n2);
            } else {
                if ((n3 = BitUtils.roundingRightShift(n3, 8)) == 0x1000000) {
                    n3 = 0x800000;
                    ++n2;
                }
                if (n2 > 96) {
                    n3 = 2139095040;
                } else {
                    n3 ^= 0x800000;
                    n3 |= n2 + 158 << 23;
                }
            }
        }
        if (bl2) {
            n3 |= Integer.MIN_VALUE;
        }
        return n3;
    }

    public static boolean isNaN(int n2) {
        return (n2 & Integer.MAX_VALUE) > 2139095040;
    }

    public static boolean isInfinite(int n2) {
        return (n2 & Integer.MAX_VALUE) == 2139095040;
    }

    public static boolean isZero(int n2) {
        return (n2 & Integer.MAX_VALUE) == 0;
    }

    public static int abs(int n2) {
        return n2 & Integer.MAX_VALUE;
    }

    public static int negate(int n2) {
        if (MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        return n2 ^ Integer.MIN_VALUE;
    }

    public static boolean eq(int n2, int n3) {
        return n2 == n3 && !MicroFloat.isNaN(n2) || MicroFloat.isZero(n2) && MicroFloat.isZero(n3);
    }

    public static boolean ne(int n2, int n3) {
        return !MicroFloat.eq(n2, n3);
    }

    public static boolean lt(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return false;
        }
        if (n3 == 0) {
            n3 = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(n2, n3) < 0;
    }

    public static boolean le(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return false;
        }
        if (n3 == Integer.MIN_VALUE) {
            n3 = 0;
        }
        return MicroFloat.cmp(n2, n3) <= 0;
    }

    public static boolean gt(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return false;
        }
        if (n2 == 0) {
            n2 = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(n2, n3) > 0;
    }

    public static boolean ge(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return false;
        }
        if (n2 == Integer.MIN_VALUE) {
            n2 = 0;
        }
        return MicroFloat.cmp(n2, n3) >= 0;
    }

    public static int compare(int n2, int n3) {
        boolean bl2 = MicroFloat.isNaN(n2);
        boolean bl3 = MicroFloat.isNaN(n3);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                return 0;
            }
            return bl2 ? 1 : -1;
        }
        return MicroFloat.cmp(n2, n3);
    }

    public static int max(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return 2143289344;
        }
        return MicroFloat.cmp(n2, n3) < 0 ? n3 : n2;
    }

    public static int min(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return 2143289344;
        }
        return MicroFloat.cmp(n2, n3) > 0 ? n3 : n2;
    }

    private static int cmp(int n2, int n3) {
        if (n2 < 0) {
            if (n3 < 0) {
                return n3 - n2;
            }
            return -1;
        }
        if (n3 < 0) {
            return 1;
        }
        return n2 - n3;
    }

    public static int intToFloat(int n2) {
        if (n2 < 0) {
            return MicroFloat.pack(true, 0, -n2);
        }
        return MicroFloat.pack(false, 0, n2);
    }

    public static int longToFloat(long l2) {
        if (l2 < 0L) {
            return MicroFloat.pack(true, 0, -l2);
        }
        return MicroFloat.pack(false, 0, l2);
    }

    public static int doubleToFloat(long l2) {
        if (MicroDouble.isNaN(l2)) {
            return 2143289344;
        }
        boolean bl2 = MicroDouble.unpackSign(l2);
        if (MicroDouble.isZero(l2)) {
            return bl2 ? Integer.MIN_VALUE : 0;
        }
        if (MicroDouble.isInfinite(l2)) {
            return bl2 ? -8388608 : 2139095040;
        }
        int n2 = MicroDouble.unpackExponent(l2);
        long l3 = MicroDouble.unpackMantissa(l2);
        return MicroFloat.pack(bl2, n2, l3);
    }

    public static byte byteValue(int n2) {
        long l2 = MicroFloat.intValue(n2);
        return (byte)l2;
    }

    public static short shortValue(int n2) {
        long l2 = MicroFloat.intValue(n2);
        return (short)l2;
    }

    public static int intValue(int n2) {
        long l2 = MicroFloat.longValue(n2);
        if (l2 >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static long longValue(int n2) {
        if (MicroFloat.isNaN(n2)) {
            return 0L;
        }
        boolean bl2 = MicroFloat.unpackSign(n2);
        int n3 = MicroFloat.unpackExponent(n2);
        long l2 = MicroFloat.unpackMantissa(n2);
        if (n3 > 0) {
            if (n3 >= 63 || l2 >> 63 - n3 != 0L) {
                return bl2 ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            l2 <<= n3;
        } else {
            if (n3 <= -24) {
                return 0L;
            }
            l2 >>>= -n3;
        }
        return bl2 ? -l2 : l2;
    }

    public static long doubleValue(int n2) {
        return MicroDouble.floatToDouble(n2);
    }

    public static int add(int n2, int n3) {
        int n4;
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return 2143289344;
        }
        boolean bl2 = MicroFloat.unpackSign(n2);
        boolean bl3 = MicroFloat.unpackSign(n3);
        boolean bl4 = MicroFloat.isInfinite(n2);
        boolean bl5 = MicroFloat.isInfinite(n3);
        if (bl4 || bl5) {
            if (bl4 && bl5) {
                if (bl2 != bl3) {
                    return 2143289344;
                }
                return n2;
            }
            if (bl4) {
                return n2;
            }
            return n3;
        }
        boolean bl6 = MicroFloat.isZero(n2);
        boolean bl7 = MicroFloat.isZero(n3);
        if (bl6 || bl7) {
            if (bl6 && bl7) {
                if (bl2 != bl3) {
                    return 0;
                }
                return n2;
            }
            if (bl6) {
                return n3;
            }
            return n2;
        }
        int n5 = MicroFloat.unpackMantissa(n2) << 3;
        int n6 = MicroFloat.unpackExponent(n2) - 3;
        int n7 = MicroFloat.unpackMantissa(n3) << 3;
        int n8 = MicroFloat.unpackExponent(n3) - 3;
        int n9 = n6 - n8;
        if (n9 > 0) {
            n7 = BitUtils.stickyRightShift(n7, n9);
            n8 = n6;
        } else if (n9 < 0) {
            n5 = BitUtils.stickyRightShift(n5, -n9);
            n6 = n8;
        }
        if (bl2 ^ bl3) {
            if (n5 > n7) {
                n7 = -n7;
            } else {
                n5 = -n5;
                bl2 = bl3;
            }
        }
        if ((n4 = MicroFloat.pack(bl2, n6, n5 += n7)) == Integer.MIN_VALUE) {
            return 0;
        }
        return n4;
    }

    public static int sub(int n2, int n3) {
        return MicroFloat.add(n2, MicroFloat.negate(n3));
    }

    public static int mul(int n2, int n3) {
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return 2143289344;
        }
        boolean bl2 = MicroFloat.unpackSign(n2) ^ MicroFloat.unpackSign(n3);
        if (MicroFloat.isInfinite(n2) || MicroFloat.isInfinite(n3)) {
            if (MicroFloat.isZero(n2) || MicroFloat.isZero(n3)) {
                return 2143289344;
            }
            return bl2 ? -8388608 : 2139095040;
        }
        int n4 = MicroFloat.unpackMantissa(n2);
        int n5 = MicroFloat.unpackExponent(n2);
        int n6 = MicroFloat.unpackMantissa(n3);
        int n7 = MicroFloat.unpackExponent(n3);
        long l2 = (long)n4 * (long)n6;
        return MicroFloat.pack(bl2, n5 += n7, l2);
    }

    public static int div(int n2, int n3) {
        boolean bl2;
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3)) {
            return 2143289344;
        }
        boolean bl3 = MicroFloat.unpackSign(n2) ^ MicroFloat.unpackSign(n3);
        boolean bl4 = MicroFloat.isInfinite(n2);
        boolean bl5 = MicroFloat.isInfinite(n3);
        if (bl4 || bl5) {
            if (bl4 && bl5) {
                return 2143289344;
            }
            if (bl4) {
                return bl3 ? -8388608 : 2139095040;
            }
            return bl3 ? Integer.MIN_VALUE : 0;
        }
        bl4 = MicroFloat.isZero(n2);
        bl5 = MicroFloat.isZero(n3);
        if (bl4 || bl5) {
            if (bl4 && bl5) {
                return 2143289344;
            }
            if (bl4) {
                return bl3 ? Integer.MIN_VALUE : 0;
            }
            return bl3 ? -8388608 : 2139095040;
        }
        int n4 = MicroFloat.unpackMantissa(n2);
        int n5 = MicroFloat.unpackExponent(n2);
        int n6 = MicroFloat.unpackMantissa(n3);
        int n7 = MicroFloat.unpackExponent(n3);
        int n8 = BitUtils.countLeadingZeros(n4) + 22;
        long l2 = (long)n4 << n8;
        int n9 = n5 - n7 - n8;
        long l3 = l2 / (long)n6;
        boolean bl6 = bl2 = l3 * (long)n6 != l2;
        if (bl2) {
            l3 |= 1L;
        }
        return MicroFloat.pack(bl3, n9, l3);
    }

    public static int mod(int n2, int n3) {
        int n4;
        if (MicroFloat.isNaN(n2) || MicroFloat.isNaN(n3) || MicroFloat.isInfinite(n2) || MicroFloat.isZero(n3)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(n2) || MicroFloat.isInfinite(n3)) {
            return n2;
        }
        int n5 = MicroFloat.unpackExponent(n2);
        if (n5 < (n4 = MicroFloat.unpackExponent(n3))) {
            return n2;
        }
        boolean bl2 = MicroFloat.unpackSign(n2);
        int n6 = MicroFloat.unpackMantissa(n2);
        int n7 = MicroFloat.unpackMantissa(n3);
        if (n5 == n4) {
            n6 %= n7;
        } else {
            while (n5 != n4) {
                int n8 = Math.min(39, n5 - n4);
                n5 -= n8;
                n6 = (int)(((long)n6 << n8) % (long)n7);
            }
        }
        return MicroFloat.pack(bl2, n5, n6);
    }

    public static int truncate(int n2) {
        return MicroFloat.round(n2, false, MicroFloat.unpackSign(n2));
    }

    public static int rint(int n2) {
        return MicroFloat.round(n2, true, false);
    }

    public static int floor(int n2) {
        return MicroFloat.round(n2, false, false);
    }

    public static int ceil(int n2) {
        return MicroFloat.round(n2, false, true);
    }

    public static int round(int n2) {
        return MicroFloat.intValue(MicroFloat.floor(MicroFloat.add(n2, 0x3F000000)));
    }

    private static int round(int n2, boolean bl2, boolean bl3) {
        if (MicroFloat.isNaN(n2)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(n2) || MicroFloat.isInfinite(n2)) {
            return n2;
        }
        int n3 = MicroFloat.unpackExponent(n2);
        if (n3 >= 0) {
            return n2;
        }
        boolean bl4 = MicroFloat.unpackSign(n2);
        int n4 = MicroFloat.unpackMantissa(n2);
        if (bl2) {
            n4 = BitUtils.roundingRightShift(n4, -n3);
        } else {
            int n5;
            if (n3 <= -32) {
                n5 = n4;
                n4 = 0;
            } else {
                n5 = n4 << 32 + n3;
                n4 >>>= -n3;
            }
            if (bl4 ^ bl3 && n5 != 0) {
                ++n4;
            }
        }
        return MicroFloat.pack(bl4, 0, n4);
    }

    private static int decToFloat(boolean bl2, int n2, int n3) {
        boolean bl3;
        if (n3 == 0) {
            return bl2 ? Integer.MIN_VALUE : 0;
        }
        while (n3 > 0 && n3 <= 0x19999999) {
            n3 = (n3 << 3) + (n3 << 1);
            --n2;
        }
        boolean bl4 = bl3 = ((n2 += 54) & 1) != 0;
        if ((n2 >>= 1) < 0) {
            return bl2 ? Integer.MIN_VALUE : 0;
        }
        if (n2 > 46) {
            return bl2 ? -8388608 : 2139095040;
        }
        int n4 = pow10x[n2];
        long l2 = ((long)n3 & 0xFFFFFFFFL) * ((long)pow10m[n2] & 0xFFFFFFFFL);
        if (bl3) {
            if (l2 < 0L) {
                l2 >>>= 1;
                ++n4;
            }
            l2 += l2 >>> 2;
            n4 += 3;
        }
        return MicroFloat.pack(bl2, n4, l2);
    }

    public static int parseFloat(String string) {
        int n2 = (string = string.trim().toUpperCase()).length();
        if (n2 == 0) {
            throw new NumberFormatException(string);
        }
        if ("NAN".equals(string)) {
            return 2143289344;
        }
        int n3 = 0;
        boolean bl2 = false;
        char c2 = string.charAt(0);
        boolean bl3 = bl2 = c2 == '-';
        if (bl2 || c2 == '+') {
            n3 = 1;
        }
        if (n3 < n2 && ((c2 = string.charAt(n3)) == 'I' || c2 == 'i') && "INFINITY".equals(string.substring(n3))) {
            return bl2 ? -8388608 : 2139095040;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (c2 == '.') {
                if (bl5) {
                    throw new NumberFormatException(string);
                }
                bl5 = true;
            } else {
                if (c2 < '0' || c2 > '9') break;
                ++n6;
                if (n4 <= 0x19999998) {
                    n4 = (n4 << 3) + (n4 << 1) + (c2 - 48);
                    if (bl5) {
                        --n5;
                    }
                } else {
                    if (!bl5) {
                        ++n5;
                    }
                    bl4 |= c2 != '0';
                }
            }
            ++n3;
        }
        if (n6 == 0) {
            throw new NumberFormatException(string);
        }
        if (n3 + 1 < n2 && (string.charAt(n3) == 'E' || string.charAt(n3) == 'e')) {
            try {
                n5 += Integer.parseInt(string.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(string);
            }
            n3 = n2;
        } else if (n3 != n2) {
            throw new NumberFormatException(string);
        }
        return MicroFloat.decToFloat(bl2, n5, n4);
    }

    public static String toString(int n2) {
        int n3;
        int n4;
        int n5;
        if (MicroFloat.isNaN(n2)) {
            return "NaN";
        }
        boolean bl2 = MicroFloat.unpackSign(n2);
        StringBuffer stringBuffer = new StringBuffer(15);
        if (bl2) {
            stringBuffer.append('-');
        }
        if (MicroFloat.isZero(n2)) {
            stringBuffer.append("0.0");
            return stringBuffer.toString();
        }
        if (MicroFloat.isInfinite(n2)) {
            stringBuffer.append("Infinity");
            return stringBuffer.toString();
        }
        int n6 = MicroFloat.unpackExponent(n2);
        int n7 = MicroFloat.unpackMantissa(n2);
        int n8 = n6 + 150;
        int n9 = n8 & 7;
        n7 <<= n9;
        int n10 = pow2x[n8 >>= 3];
        while (n7 <= 0xCCCCCCC) {
            n7 = (n7 << 3) + (n7 << 1);
            --n10;
        }
        long l2 = (long)n7 * ((long)pow2m[n8] & 0xFFFFFFFFL);
        int n11 = (int)(l2 >>> 32);
        if (l2 << 32 < 0L) {
            ++n11;
        }
        boolean bl3 = false;
        while (true) {
            int n12 = n11 % 10;
            n5 = n11 / 10;
            n4 = n10 + 1;
            if (n12 != 0) {
                if (n12 > 5 || n12 == 5 && !bl3) {
                    bl3 = true;
                    ++n5;
                } else {
                    bl3 = false;
                }
                n3 = MicroFloat.decToFloat(bl2, n4, n5);
                if (n3 != n2) {
                    n5 = bl3 ? --n5 : ++n5;
                    bl3 ^= true;
                    n3 = MicroFloat.decToFloat(bl2, n4, n5);
                    if (n3 != n2) break;
                }
            }
            n11 = n5;
            n10 = n4;
        }
        String string = Integer.toString(n11);
        int n13 = n5 = (n10 += string.length() - 1) < -3 || n10 >= 7 ? 1 : 0;
        if (n5 != 0) {
            n4 = 1;
        } else {
            n4 = n10 + 1;
            if (n4 < 1) {
                stringBuffer.append('0');
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 < string.length()) {
                stringBuffer.append(string.charAt(n3));
                continue;
            }
            stringBuffer.append('0');
        }
        stringBuffer.append('.');
        if (n4 >= string.length()) {
            stringBuffer.append('0');
        } else {
            for (n3 = n4; n3 < string.length(); ++n3) {
                if (n3 < 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(string.charAt(n3));
            }
        }
        if (n5 != 0) {
            stringBuffer.append('E');
            stringBuffer.append(Integer.toString(n10));
        }
        return stringBuffer.toString();
    }

    public MicroFloat(int n2) {
        if (MicroFloat.isNaN(n2)) {
            n2 = 2143289344;
        }
        this.value = n2;
    }

    public MicroFloat(String string) {
        this(MicroFloat.parseFloat(string));
    }

    public int floatValue() {
        return this.value;
    }

    public String toString() {
        return MicroFloat.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof MicroFloat && ((MicroFloat)object).value == this.value;
    }
}

