/*
 * Decompiled with CFR 0.152.
 */
package googleAddressLocation;

import googleAddressLocation.MicroDouble;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class GoogleMaps {
    String apiKey;
    int offset = 0x10000000;
    double radius = (double)this.offset / Math.PI;

    public GoogleMaps(String string) {
        this.apiKey = string;
    }

    public double[] geocodeAddress(String string) throws Exception {
        byte[] byArray = this.loadHttpFile(this.getGeocodeUrl(string));
        String string2 = new String(byArray, 0, byArray.length);
        System.out.println("geocodeAddress address=" + string);
        System.out.println("    -> " + string2);
        String[] stringArray = GoogleMaps.split(string2, 44);
        if (stringArray[0].compareTo("200") != 0) {
            int n2 = Integer.parseInt(stringArray[0]);
            throw new Exception("Google Maps Exception: " + this.getGeocodeError(n2));
        }
        return new double[]{Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3])};
    }

    public Image retrieveStaticImage(int n2, int n3, double d2, double d3, int n4, String string) throws Exception {
        byte[] byArray = this.loadHttpFile(this.getMapUrl(n2, n3, d3, d2, n4, string));
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    String getGeocodeError(int n2) {
        switch (n2) {
            case 400: {
                return "Bad request";
            }
            case 500: {
                return "Server error";
            }
            case 601: {
                return "Missing query";
            }
            case 602: {
                return "Unknown address";
            }
            case 603: {
                return "Unavailable address";
            }
            case 604: {
                return "Unknown directions";
            }
            case 610: {
                return "Bad API key";
            }
            case 620: {
                return "Too many queries";
            }
        }
        return "Generic error";
    }

    String getGeocodeUrl(String string) {
        return "http://maps.google.com/maps/geo?q=" + this.urlEncode(string) + "&output=csv&key=" + this.apiKey;
    }

    String getMapUrl(int n2, int n3, double d2, double d3, int n4, String string) {
        return "http://maps.google.com/staticmap?center=" + d3 + "," + d2 + "&format=" + string + "&zoom=" + n4 + "&size=" + n2 + "x" + n3 + "&key=" + this.apiKey;
    }

    String urlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append("%").append(Integer.toHexString(string.charAt(i2)));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] loadHttpFile(String string) throws Exception {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        System.out.println("loadHttpFile url=" + string);
        try {
            int n2;
            httpConnection = (HttpConnection)Connector.open((String)string);
            httpConnection.setRequestMethod("GET");
            inputStream = httpConnection.openInputStream();
            int n3 = (int)httpConnection.getLength();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    static String[] split(String string, int n2) {
        System.out.println("split= " + string);
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = 0;
        while ((n3 = string.indexOf(n2, n4)) >= 0) {
            vector.addElement(string.substring(n4, n3));
            n4 = n3 + 1;
        }
        vector.addElement(string.substring(n4));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected final void destroy() {
    }

    public double[] adjust(double d2, double d3, int n2, int n3, int n4) {
        return new double[]{this.XToL(this.LToX(d2) + (double)(n3 << 21 - n4)), this.YToL(this.LToY(d3) + (double)(n2 << 21 - n4))};
    }

    double LToX(double d2) {
        return this.round((double)this.offset + this.radius * d2 * Math.PI / 180.0);
    }

    double LToY(double d2) {
        return this.round((double)this.offset - this.radius * Double.longBitsToDouble(MicroDouble.log(Double.doubleToLongBits((1.0 + Math.sin(d2 * Math.PI / 180.0)) / (1.0 - Math.sin(d2 * Math.PI / 180.0))))) / 2.0);
    }

    double XToL(double d2) {
        return (this.round(d2) - (double)this.offset) / this.radius * 180.0 / Math.PI;
    }

    double YToL(double d2) {
        return (1.5707963267948966 - 2.0 * Double.longBitsToDouble(MicroDouble.atan(MicroDouble.exp(Double.doubleToLongBits((this.round(d2) - (double)this.offset) / this.radius))))) * 180.0 / Math.PI;
    }

    double round(double d2) {
        double d3 = Math.floor(d2);
        if (d2 - d3 >= 0.5) {
            return Math.ceil(d2);
        }
        return d3;
    }
}

