/*
 * Decompiled with CFR 0.152.
 */
package googleAddressLocation;

final class BitUtils {
    private BitUtils() {
    }

    static int countLeadingZeros(int n2) {
        if (n2 <= 0) {
            if (n2 == 0) {
                return 32;
            }
            return 0;
        }
        int n3 = 0;
        if ((n2 & 0xFFFF0000) == 0) {
            n2 <<= 16;
            n3 = 16;
        }
        if ((n2 & 0xFF000000) == 0) {
            n2 <<= 8;
            n3 += 8;
        }
        while (n2 > 0) {
            ++n3;
            n2 <<= 1;
        }
        return n3;
    }

    static int countLeadingZeros(long l2) {
        int n2 = BitUtils.countLeadingZeros((int)(l2 >> 32));
        if (n2 == 32) {
            return BitUtils.countLeadingZeros((int)l2) + 32;
        }
        return n2;
    }

    static int stickyRightShift(int n2, int n3) {
        if (n3 >= 32) {
            return n2 == 0 ? 0 : 1;
        }
        if (n2 << 32 - n3 == 0) {
            return n2 >>> n3;
        }
        return n2 >>> n3 | 1;
    }

    static long stickyRightShift(long l2, int n2) {
        if (n2 >= 64) {
            return l2 == 0L ? 0 : 1;
        }
        if (l2 << 64 - n2 == 0L) {
            return l2 >>> n2;
        }
        return l2 >>> n2 | 1L;
    }

    static int roundingRightShift(int n2, int n3) {
        int n4;
        if (n3 > 32) {
            return 0;
        }
        if (n3 == 32) {
            n4 = n2;
            n2 = 0;
        } else {
            n4 = n2 << 32 - n3;
            n2 >>>= n3;
        }
        if (n4 < 0 && (n4 != Integer.MIN_VALUE || (n2 & 1) == 1)) {
            return n2 + 1;
        }
        return n2;
    }

    static long roundingRightShift(long l2, int n2) {
        long l3;
        if (n2 > 64) {
            return 0L;
        }
        if (n2 == 64) {
            l3 = l2;
            l2 = 0L;
        } else {
            l3 = l2 << 64 - n2;
            l2 >>>= n2;
        }
        if (l3 < 0L && (l3 != Long.MIN_VALUE || (l2 & 1L) == 1L)) {
            return l2 + 1L;
        }
        return l2;
    }
}

