/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothL2CAPConnection;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.Utils;
import java.io.IOException;

class BluetoothL2CAPClientConnection
extends BluetoothL2CAPConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothL2CAPClientConnection(BluetoothStack bluetoothStack, BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        super(bluetoothStack, bluetoothStack.l2OpenClientConnection(params, receiveMTU, transmitMTU));
        boolean initOK = false;
        try {
            this.securityOpt = bluetoothStack.l2GetSecurityOpt(this.handle, Utils.securityOpt(params.authenticate, params.encrypt));
            RemoteDeviceHelper.connected(this);
            initOK = true;
        }
        finally {
            if (!initOK) {
                try {
                    bluetoothStack.l2CloseClientConnection(this.handle);
                }
                catch (IOException e) {
                    DebugLog.error("close error", e);
                }
            }
        }
    }

    void closeConnectionHandle(long handle) throws IOException {
        RemoteDeviceHelper.disconnected(this);
        this.bluetoothStack.l2CloseClientConnection(handle);
    }
}

