/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import java.util.Hashtable;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.UUID;

public abstract class BluetoothConsts {
    public static final String SHORT_UUID_BASE = "00001000800000805F9B34FB";
    public static final String PROTOCOL_SCHEME_L2CAP = "btl2cap";
    public static final String PROTOCOL_SCHEME_RFCOMM = "btspp";
    public static final String PROTOCOL_SCHEME_BT_OBEX = "btgoep";
    public static final String PROTOCOL_SCHEME_TCP_OBEX = "tcpobex";
    public static final UUID L2CAP_PROTOCOL_UUID = new UUID(256L);
    public static final UUID RFCOMM_PROTOCOL_UUID = new UUID(3L);
    public static final UUID OBEX_PROTOCOL_UUID = new UUID(8L);
    public static final UUID OBEXFileTransferServiceClass_UUID = new UUID(4358L);
    public static final int RFCOMM_CHANNEL_MIN = 1;
    public static final int RFCOMM_CHANNEL_MAX = 30;
    public static final int L2CAP_PSM_MIN = 5;
    public static final int L2CAP_PSM_MIN_JSR_82 = 4097;
    public static final int L2CAP_PSM_MAX = 65535;
    public static final int TCP_OBEX_DEFAULT_PORT = 650;
    public static final String PROPERTY_BLUETOOTH_API_VERSION = "bluetooth.api.version";
    public static final String PROPERTY_OBEX_API_VERSION = "obex.api.version";
    public static final String PROPERTY_BLUETOOTH_MASTER_SWITCH = "bluetooth.master.switch";
    public static final String PROPERTY_BLUETOOTH_SD_ATTR_RETRIEVABLE_MAX = "bluetooth.sd.attr.retrievable.max";
    public static final String PROPERTY_BLUETOOTH_CONNECTED_DEVICES_MAX = "bluetooth.connected.devices.max";
    public static final String PROPERTY_BLUETOOTH_L2CAP_RECEIVEMTU_MAX = "bluetooth.l2cap.receiveMTU.max";
    public static final String PROPERTY_BLUETOOTH_SD_TRANS_MAX = "bluetooth.sd.trans.max";
    public static final String PROPERTY_BLUETOOTH_CONNECTED_INQUIRY_SCAN = "bluetooth.connected.inquiry.scan";
    public static final String PROPERTY_BLUETOOTH_CONNECTED_PAGE_SCAN = "bluetooth.connected.page.scan";
    public static final String PROPERTY_BLUETOOTH_CONNECTED_INQUIRY = "bluetooth.connected.inquiry";
    public static final String PROPERTY_BLUETOOTH_CONNECTED_PAGE = "bluetooth.connected.page";
    static Hashtable obexUUIDs = new Hashtable();
    public static final UUID SERIAL_PORT_UUID;
    public static final int BluetoothProfileDescriptorList = 9;
    public static final int BrowseGroupList = 5;
    public static final int ClientExecutableURL = 11;
    public static final int DocumentationURL = 10;
    public static final int IconURL = 12;
    public static final int LanguageBasedAttributeIDList = 6;
    public static final int ProtocolDescriptorList = 4;
    public static final int ProviderName = 2;
    public static final int ServiceAvailability = 8;
    public static final int ServiceClassIDList = 1;
    public static final int ServiceDatabaseState = 513;
    public static final int ServiceDescription = 1;
    public static final int ServiceID = 3;
    public static final int ServiceInfoTimeToLive = 7;
    public static final int AttributeIDServiceName = 256;
    public static final int ServiceName = 0;
    public static final int ServiceRecordHandle = 0;
    public static final int ServiceRecordState = 2;
    public static final int VersionNumberList = 512;

    private BluetoothConsts() {
    }

    private static void addObex(int uuid) {
        UUID u = new UUID(uuid);
        obexUUIDs.put(u, u);
    }

    public static String toString(DeviceClass dc) {
        return DeviceClassConsts.toString(dc);
    }

    static {
        BluetoothConsts.addObex(4356);
        BluetoothConsts.addObex(4357);
        BluetoothConsts.addObex(4358);
        BluetoothConsts.addObex(4359);
        BluetoothConsts.addObex(4379);
        SERIAL_PORT_UUID = new UUID(4353L);
    }

    static class DeviceClassConsts {
        public static final int SERVICE_MASK = 0xFFE000;
        public static final int MAJOR_MASK = 7936;
        public static final int MINOR_MASK = 252;
        public static final int FORMAT_VERSION_MASK = 3;
        public static final int LIMITED_DISCOVERY_SERVICE = 8192;
        public static final int RESERVED1_SERVICE = 16384;
        public static final int RESERVED2_SERVICE = 32768;
        public static final int POSITIONING_SERVICE = 65536;
        public static final int NETWORKING_SERVICE = 131072;
        public static final int RENDERING_SERVICE = 262144;
        public static final int CAPTURING_SERVICE = 524288;
        public static final int OBJECT_TRANSFER_SERVICE = 0x100000;
        public static final int AUDIO_SERVICE = 0x200000;
        public static final int TELEPHONY_SERVICE = 0x400000;
        public static final int INFORMATION_SERVICE = 0x800000;
        public static final int MAJOR_MISCELLANEOUS = 0;
        public static final int MAJOR_COMPUTER = 256;
        public static final int MAJOR_PHONE = 512;
        public static final int MAJOR_LAN_ACCESS = 768;
        public static final int MAJOR_AUDIO = 1024;
        public static final int MAJOR_PERIPHERAL = 1280;
        public static final int MAJOR_IMAGING = 1536;
        public static final int MAJOR_UNCLASSIFIED = 7936;
        public static final int COMPUTER_MINOR_UNCLASSIFIED = 0;
        public static final int COMPUTER_MINOR_DESKTOP = 4;
        public static final int COMPUTER_MINOR_SERVER = 8;
        public static final int COMPUTER_MINOR_LAPTOP = 12;
        public static final int COMPUTER_MINOR_HANDHELD = 16;
        public static final int COMPUTER_MINOR_PALM = 20;
        public static final int COMPUTER_MINOR_WEARABLE = 24;
        public static final int PHONE_MINOR_UNCLASSIFIED = 0;
        public static final int PHONE_MINOR_CELLULAR = 4;
        public static final int PHONE_MINOR_CORDLESS = 8;
        public static final int PHONE_MINOR_SMARTPHONE = 12;
        public static final int PHONE_MINOR_WIRED_MODEM = 16;
        public static final int PHONE_MINOR_ISDN = 20;
        public static final int PHONE_MINOR_BANANA = 24;
        public static final int LAN_MINOR_TYPE_MASK = 28;
        public static final int LAN_MINOR_ACCESS_MASK = 224;
        public static final int LAN_MINOR_UNCLASSIFIED = 0;
        public static final int LAN_MINOR_ACCESS_0_USED = 0;
        public static final int LAN_MINOR_ACCESS_17_USED = 32;
        public static final int LAN_MINOR_ACCESS_33_USED = 64;
        public static final int LAN_MINOR_ACCESS_50_USED = 96;
        public static final int LAN_MINOR_ACCESS_67_USED = 128;
        public static final int LAN_MINOR_ACCESS_83_USED = 160;
        public static final int LAN_MINOR_ACCESS_99_USED = 192;
        public static final int LAN_MINOR_ACCESS_FULL = 224;
        public static final int AUDIO_MINOR_UNCLASSIFIED = 0;
        public static final int AUDIO_MINOR_HEADSET = 4;
        public static final int AUDIO_MINOR_HANDS_FREE = 8;
        public static final int AUDIO_MINOR_MICROPHONE = 16;
        public static final int AUDIO_MINOR_LOUDSPEAKER = 20;
        public static final int AUDIO_MINOR_HEADPHONES = 24;
        public static final int AUDIO_MINOR_PORTABLE_AUDIO = 28;
        public static final int AUDIO_MINOR_CAR_AUDIO = 32;
        public static final int AUDIO_MINOR_SET_TOP_BOX = 36;
        public static final int AUDIO_MINOR_HIFI_AUDIO = 40;
        public static final int AUDIO_MINOR_VCR = 44;
        public static final int AUDIO_MINOR_VIDEO_CAMERA = 48;
        public static final int AUDIO_MINOR_CAMCORDER = 52;
        public static final int AUDIO_MINOR_VIDEO_MONITOR = 56;
        public static final int AUDIO_MINOR_VIDEO_DISPLAY_LOUDSPEAKER = 60;
        public static final int AUDIO_MINOR_VIDEO_DISPLAY_CONFERENCING = 64;
        public static final int AUDIO_MINOR_GAMING_TOY = 72;
        public static final int PERIPHERAL_MINOR_TYPE_MASK = 60;
        public static final int PERIPHERAL_MINOR_KEYBOARD_MASK = 64;
        public static final int PERIPHERAL_MINOR_POINTER_MASK = 128;
        public static final int PERIPHERAL_MINOR_UNCLASSIFIED = 0;
        public static final int PERIPHERAL_MINOR_JOYSTICK = 4;
        public static final int PERIPHERAL_MINOR_GAMEPAD = 8;
        public static final int PERIPHERAL_MINOR_REMOTE_CONTROL = 12;
        public static final int PERIPHERAL_MINOR_SENSING = 16;
        public static final int PERIPHERAL_MINOR_DIGITIZER = 20;
        public static final int PERIPHERAL_MINOR_CARD_READER = 24;
        public static final int IMAGING_MINOR_DISPLAY_MASK = 16;
        public static final int IMAGING_MINOR_CAMERA_MASK = 32;
        public static final int IMAGING_MINOR_SCANNER_MASK = 64;
        public static final int IMAGING_MINOR_PRINTER_MASK = 128;

        DeviceClassConsts() {
        }

        private static boolean append(StringBuffer buf, String str, boolean comma) {
            if (comma) {
                buf.append(',');
            }
            buf.append(str);
            return true;
        }

        public static String toString(DeviceClass dc) {
            StringBuffer buf = new StringBuffer();
            block0 : switch (dc.getMajorDeviceClass()) {
                case 0: {
                    buf.append("Miscellaneous");
                    break;
                }
                case 256: {
                    buf.append("Computer");
                    switch (dc.getMinorDeviceClass()) {
                        case 0: {
                            buf.append("/Unclassified");
                            break block0;
                        }
                        case 4: {
                            buf.append("/Desktop");
                            break block0;
                        }
                        case 8: {
                            buf.append("/Server");
                            break block0;
                        }
                        case 12: {
                            buf.append("/Laptop");
                            break block0;
                        }
                        case 16: {
                            buf.append("/Handheld");
                            break block0;
                        }
                        case 20: {
                            buf.append("/Palm");
                            break block0;
                        }
                        case 24: {
                            buf.append("/Wearable");
                            break block0;
                        }
                    }
                    buf.append("/Unknown");
                    break;
                }
                case 512: {
                    buf.append("Phone");
                    switch (dc.getMinorDeviceClass()) {
                        case 0: {
                            buf.append("/Unclassified");
                            break block0;
                        }
                        case 4: {
                            buf.append("/Cellular");
                            break block0;
                        }
                        case 8: {
                            buf.append("/Cordless");
                            break block0;
                        }
                        case 12: {
                            buf.append("/Smartphone");
                            break block0;
                        }
                        case 16: {
                            buf.append("/Wired Modem");
                            break block0;
                        }
                        case 20: {
                            buf.append("/ISDN");
                            break block0;
                        }
                        case 24: {
                            buf.append("/Ring ring ring ring ring ring ring");
                            break block0;
                        }
                    }
                    buf.append("/Unknown");
                    break;
                }
                case 768: {
                    buf.append("LAN Access");
                    int minor = dc.getMinorDeviceClass();
                    switch (minor & 0x1C) {
                        case 0: {
                            buf.append("/Unclassified");
                            break;
                        }
                        default: {
                            buf.append("/Unknown");
                        }
                    }
                    switch (minor & 0xE0) {
                        case 0: {
                            buf.append("/0% used");
                            break;
                        }
                        case 32: {
                            buf.append("/1-17% used");
                            break;
                        }
                        case 64: {
                            buf.append("/18-33% used");
                            break;
                        }
                        case 96: {
                            buf.append("/34-50% used");
                            break;
                        }
                        case 128: {
                            buf.append("/51-67% used");
                            break;
                        }
                        case 160: {
                            buf.append("/68-83% used");
                            break;
                        }
                        case 192: {
                            buf.append("/84-99% used");
                            break;
                        }
                        case 224: {
                            buf.append("/100% used");
                        }
                    }
                    break;
                }
                case 1024: {
                    buf.append("Audio");
                    switch (dc.getMinorDeviceClass()) {
                        case 0: {
                            buf.append("/Unclassified");
                            break block0;
                        }
                        case 4: {
                            buf.append("/Headset");
                            break block0;
                        }
                        case 8: {
                            buf.append("/Hands-free");
                            break block0;
                        }
                        case 16: {
                            buf.append("/Microphone");
                            break block0;
                        }
                        case 20: {
                            buf.append("/Loudspeaker");
                            break block0;
                        }
                        case 24: {
                            buf.append("/Headphones");
                            break block0;
                        }
                        case 28: {
                            buf.append("/Portable");
                            break block0;
                        }
                        case 32: {
                            buf.append("/Car");
                            break block0;
                        }
                        case 36: {
                            buf.append("/Set-top Box");
                            break block0;
                        }
                        case 40: {
                            buf.append("/HiFi");
                            break block0;
                        }
                        case 44: {
                            buf.append("/VCR");
                            break block0;
                        }
                        case 48: {
                            buf.append("/Video Camera");
                            break block0;
                        }
                        case 52: {
                            buf.append("/Camcorder");
                            break block0;
                        }
                        case 56: {
                            buf.append("/Video Monitor");
                            break block0;
                        }
                        case 60: {
                            buf.append("/Video Display Loudspeaker");
                            break block0;
                        }
                        case 64: {
                            buf.append("/Video Display Conferencing");
                            break block0;
                        }
                        case 72: {
                            buf.append("/Gaming Toy");
                            break block0;
                        }
                    }
                    buf.append("/Unknown");
                    break;
                }
                case 1280: {
                    buf.append("Peripheral");
                    int minor = dc.getMinorDeviceClass();
                    switch (minor & 0xC0) {
                        case 0: {
                            buf.append("/()");
                            break;
                        }
                        case 64: {
                            buf.append("/(Keyboard)");
                            break;
                        }
                        case 128: {
                            buf.append("/(Pointer)");
                            break;
                        }
                        case 192: {
                            buf.append("/(Keyboard,Pointer)");
                        }
                    }
                    switch (minor & 0x3C) {
                        case 0: {
                            buf.append("/Unclassified");
                            break block0;
                        }
                        case 4: {
                            buf.append("/Joystick");
                            break block0;
                        }
                        case 8: {
                            buf.append("/Gamepad");
                            break block0;
                        }
                        case 12: {
                            buf.append("/Remote Control");
                            break block0;
                        }
                        case 16: {
                            buf.append("/Sensing");
                            break block0;
                        }
                        case 20: {
                            buf.append("/Digitizer");
                            break block0;
                        }
                        case 24: {
                            buf.append("/Card Reader");
                            break block0;
                        }
                    }
                    buf.append("/Unknown");
                    break;
                }
                case 1536: {
                    buf.append("Peripheral/(");
                    int minor = dc.getMinorDeviceClass();
                    boolean comma = false;
                    if ((minor & 0x10) != 0) {
                        comma = DeviceClassConsts.append(buf, "Display", comma);
                    }
                    if ((minor & 0x20) != 0) {
                        comma = DeviceClassConsts.append(buf, "Camera", comma);
                    }
                    if ((minor & 0x40) != 0) {
                        comma = DeviceClassConsts.append(buf, "Scanner", comma);
                    }
                    if ((minor & 0x80) != 0) {
                        DeviceClassConsts.append(buf, "Printer", comma);
                    }
                    buf.append(')');
                    break;
                }
                case 7936: {
                    buf.append("Unclassified");
                    break;
                }
                default: {
                    buf.append("Unknown");
                }
            }
            buf.append("/(");
            boolean comma = false;
            int record = dc.getServiceClasses();
            if ((record & 0x2000) != 0) {
                comma = DeviceClassConsts.append(buf, "Limited Discovery", comma);
            }
            if ((record & 0x10000) != 0) {
                comma = DeviceClassConsts.append(buf, "Positioning", comma);
            }
            if ((record & 0x20000) != 0) {
                comma = DeviceClassConsts.append(buf, "Networking", comma);
            }
            if ((record & 0x40000) != 0) {
                comma = DeviceClassConsts.append(buf, "Rendering", comma);
            }
            if ((record & 0x80000) != 0) {
                comma = DeviceClassConsts.append(buf, "Capturing", comma);
            }
            if ((record & 0x100000) != 0) {
                comma = DeviceClassConsts.append(buf, "Object Transfer", comma);
            }
            if ((record & 0x200000) != 0) {
                comma = DeviceClassConsts.append(buf, "Audio", comma);
            }
            if ((record & 0x400000) != 0) {
                comma = DeviceClassConsts.append(buf, "Telephony", comma);
            }
            if ((record & 0x800000) != 0) {
                DeviceClassConsts.append(buf, "Information", comma);
            }
            buf.append(')');
            return buf.toString();
        }
    }
}

